/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.examples.lights;

import org.newdawn.slick.Color;

class Light {
    private float xpos;
    private float ypos;
    private float strength;
    private Color col;

    public Light(float x, float y, float str, Color col) {
        this.xpos = x;
        this.ypos = y;
        this.strength = str;
        this.col = col;
    }

    public void setLocation(float x, float y) {
        this.xpos = x;
        this.ypos = y;
    }

    public float[] getEffectAt(float x, float y, boolean colouredLights) {
        float dx = x - this.xpos;
        float dy = y - this.ypos;
        float distance2 = dx * dx + dy * dy;
        float effect = 1.0f - distance2 / (this.strength * this.strength);
        if (effect < 0.0f) {
            effect = 0.0f;
        }
        if (colouredLights) {
            return new float[]{this.col.r * effect, this.col.g * effect, this.col.b * effect};
        }
        return new float[]{effect, effect, effect};
    }
}

